// Based on has_char by user repolho at github which is Public Domain
// But reformatted with tabs
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <wchar.h>
#include <fontconfig/fontconfig.h>

#define MAX_NAME_SIZE 1024

int main(int argc, char* argv[]) {
	FcConfig *config;
	FcPattern *pattern;
	FcResult result;
	FcCharSet *charset;
	char font_name[MAX_NAME_SIZE];
	FcChar8 *font_chosen;
	wchar_t codepoint=0x20;

	// I'll never understand why you have to unset locale to use wide chars
	// KM : might not be needed by me, unsure - but it should stop attempts to
	// decide the font misses glyphs needed by my current locale (that can
	// cause it to be rejected in favour of a different font)
	setlocale(LC_CTYPE, "");

	if (argc != 2) {
		fwprintf(stderr, L"Usage: %s font_name \n", argv[0]);
		return 255;
	}
	strncpy(font_name, argv[1], MAX_NAME_SIZE);

	// Here, I tried various ways of trying to specify the Style,
	// but all of them failed, so just go with whatever is found.

	// initializing fontconfig
	if (FcInit() != FcTrue) {
		fwprintf(stderr, L"Couldn't initialize fontconfig\n");
		return 255;
	}
	config = FcInitLoadConfigAndFonts();

	// trying to select desired font
	pattern = FcNameParse((FcChar8*)font_name);
	FcDefaultSubstitute(pattern);
	FcConfigSubstitute(config, pattern, FcMatchFont);
	pattern = FcFontMatch(config, pattern, &result);

	// checking if we selected the right font (if the font is missing, fontconfig
	// will select "the closest match" (which actually means "one completely
	// different"))
	FcPatternGetString(pattern, "family", 0, &font_chosen);
	if (strlen(font_name) != strlen((char*)font_chosen) || \
		(strncmp(font_name, (char*)font_chosen, strlen(font_name)) != 0)) {
		fwprintf(stderr, L"Couldn't find font %s, aborting\n", font_name);
		return 255;
	}

	// checking all characters >= space against the font
	// in practice, experience shows that blank characters like space itself
	// are sometimes treated as not present (depends on the font).
	FcPatternGetCharSet(pattern, "charset", 0, &charset);
	while (codepoint++ < 0x100000) {
		if (FcCharSetHasChar(charset, (FcChar32)codepoint) == FcTrue) {
			printf("U+% 04x\n", codepoint);
		}
	}

}
